NAVQueryPlanCache.prototype._parseQueryShape = function (query, projection, sort) {
    if (isUndefined(query))
        nav_throwError("required parameter query missing");

    if (isObject(query) && isUndefined(projection) && isUndefined(sort) ) {
        var keysSorted = Object.keys(query).sort();
        if (Array.equals(keysSorted,['projection', 'query', 'sort'])) {
            return query;
        }
    }

    var shape = {
        query: query,
        projection: isUndefined(projection) ? {} : projection,
        sort: isUndefined(sort) ? {} : sort,
    };

    return shape;
};

NAVQueryPlanCache.prototype.clear = function () {
    var commandObj = { planCacheClear: this._collection.getName() }
    var result = this._collection.runCommand(commandObj);
    if (!result.ok) {
        nav_throwError(result.errmsg);
    }
};

NAVQueryPlanCache.prototype.clearPlansByQuery = function (query, projection, sort) {
    if (isUndefined(query))
        nav_throwError("clearPlansByQuery must have query");
    if (!isObject(query))
        nav_throwError("query must be object");
    if (!isUndefined(projection)) {
        if (!isObject(projection))
            nav_throwError("projection must be object");
    }
    if (!isUndefined(sort)) {
        if (!isObject(sort))
            nav_throwError("sort must be object");
    }

    var commandObj = { planCacheClear: this._collection.getName() };
    Object.extend(commandObj, this._parseQueryShape(query, projection, sort));

    var result = this._collection.runCommand(commandObj);
    if (!result.ok)
        nav_throwError(result.errmsg);
};

NAVQueryPlanCache.prototype.getPlansByQuery = function (query, projection, sort) {
    if (isUndefined(query))
        nav_throwError("getPlansByQuery must have query");
    if (!isObject(query))
        nav_throwError("query must be object");
    if (!isUndefined(projection)) {
        if (!isObject(projection))
            nav_throwError("projection must be object");
    }
    if (!isUndefined(sort)) {
        if (!isObject(sort))
            nav_throwError("sort must be object");
    }

    var commandObj = { planCacheListPlans: this._collection.getName() };
    Object.extend(commandObj, this._parseQueryShape(query, projection, sort));

    var result = this._collection.runCommand(commandObj);
    if (!result.ok)
        nav_throwError(result.errmsg);
    return result;
};

NAVQueryPlanCache.prototype.getCollectionName = function () {
    return this.forwardToCustomFunction("queryPlanCacheGetCollectionName");
};

NAVQueryPlanCache.prototype.help = function () {
    var collectionName = this.getCollectionName();
    print("PlanCache help\n" +
        "\tdb." + collectionName + ".getPlanCache().help() - show PlanCache help\n" +
        "\tdb." + collectionName + ".getPlanCache().listQueryShapes() - " +
        "displays all query shapes in a collection\n" +
        "\tdb." + collectionName + ".getPlanCache().clear() - " +
        "drops all cached queries in a collection\n" +
        "\tdb." + collectionName +
        ".getPlanCache().clearPlansByQuery(query[, projection, sort, collation]) - " +
        "drops query shape from plan cache\n" +
        "\tdb." + collectionName +
        ".getPlanCache().getPlansByQuery(query[, projection, sort, collation]) - " +
        "displays the cached plans for a query shape\n" +
        "\tdb." + collectionName +
        ".getPlanCache().list([pipeline]) - " +
        "displays a serialization of the plan cache for this collection, " +
        "after applying an optional aggregation pipeline");
};

NAVQueryPlanCache.prototype.listQueryShapes = function () {
    var commandObj = { planCacheListQueryShapes: this._collection.getName() };

    var result = this._collection.runCommand(commandObj);
    if (!result.ok)
        nav_throwError(result.errmsg);
    return result.shapes;
};

NAVQueryPlanCache.prototype.list = function (pipeline) {
    var additionalPipeline = pipeline || [];
    var completePipeline = [{ $planCacheStats: {} }].concat(additionalPipeline);
    return this._collection.aggregate(completePipeline).toArray();
};
